//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Collections;

namespace FrameworkLibraries
{
	public class ArrayListMain 
	{
		static void Main(string [] args)
		{
			ArrayList al = new ArrayList();
			lock(al.SyncRoot)
			{
				al.Add("To");
				al.Add("jest");
				al.Add("test");
				al.Add(0);
				al.Add(1);
				Console.WriteLine("Zsynchronizowany: {0}", al.IsSynchronized);
				Console.WriteLine("Tylko do odczytu: {0}", al.IsReadOnly);
				Console.WriteLine("Staa dugo: {0}", al.IsFixedSize);
				Console.WriteLine("Pojemno: {0}", al.Capacity);
				Console.WriteLine("Licznik: {0}", al.Count);
			}
			foreach(object o in al)
			{
				Console.WriteLine("{0} {1}", o, o.GetType());
			}
			al = ArrayList.Synchronized(al);
			Console.WriteLine("Zsynchronizowany: {0}", al.IsSynchronized);
		}
	}
}